/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskContentEvent;
import filenet.vw.apps.taskman.VWTaskContentListener;
import filenet.vw.apps.taskman.VWTaskContentViewPane;
import filenet.vw.apps.taskman.VWTaskTablePanel;
import filenet.vw.apps.taskman.VWTaskUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class VWTaskContentPane
extends JPanel
implements TreeSelectionListener,
VWTaskContentListener,
ActionListener,
TreeModelListener {
    private VWTaskBaseNode m_focus = null;
    private VWTaskContentViewPane m_currentView = null;
    private Container m_parentContainer = null;
    private Frame m_parentFrame = null;
    private EventListenerList m_actionListenerList = new EventListenerList();
    private EventListenerList m_contentListenerList = new EventListenerList();

    public VWTaskContentPane() {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
    }

    public void init(VWTaskBaseNode node, Container parentContainer, Frame parentFrame) {
        this.m_parentContainer = parentContainer;
        this.m_parentFrame = parentFrame;
        this.setFocus(node);
    }

    public VWTaskBaseNode getSelectedNode() {
        return this.m_focus;
    }

    protected void setFocus(VWTaskBaseNode node) {
        if (this.m_currentView != null) {
            this.m_currentView.clearTableSelection();
        }
        node.inFocus();
        this.m_focus = node;
        this.m_currentView = this.m_focus.getContentPane();
        this.m_currentView.setContentListener(this);
        this.m_currentView.setActionListener(this);
        this.m_currentView.refreshButtonPanel();
        this.refreshContent();
        this.fireVWTaskContentEvent(new VWTaskContentEvent(this, this.m_focus));
    }

    public void refreshContent() {
        Runnable operation = new Runnable(){

            public void run() {
                VWTaskContentPane.this.removeAll();
                SwingUtilities.updateComponentTreeUI(VWTaskContentPane.this.m_currentView);
                VWTaskContentPane.this.add((Component)VWTaskContentPane.this.m_currentView, "Center");
                VWTaskContentPane.this.revalidate();
                VWTaskContentPane.this.repaint();
            }
        };
        VWTaskUtil.performUIOperation(operation, true);
    }

    public void addActionListener(ActionListener al) {
        this.m_actionListenerList.add(ActionListener.class, al);
    }

    public void removeActionListener(ActionListener al) {
        this.m_actionListenerList.remove(ActionListener.class, al);
    }

    public void addVWTaskContentListener(VWTaskContentListener listener) {
        this.m_contentListenerList.add(VWTaskContentListener.class, listener);
    }

    public void removeVWTaskContentListener(VWTaskContentListener listener) {
        this.m_contentListenerList.remove(VWTaskContentListener.class, listener);
    }

    public void taskContentChanged(VWTaskContentEvent e) {
        this.m_focus = e.getBaseNode();
        this.fireVWTaskContentEvent(e);
    }

    public void actionPerformed(ActionEvent event) {
        this.fireActionEvent(event);
    }

    public void valueChanged(TreeSelectionEvent event) {
        TreePath path = event.getNewLeadSelectionPath();
        if (path != null) {
            VWTaskBaseNode node = (VWTaskBaseNode)path.getLastPathComponent();
            this.setFocus(node);
        }
    }

    public void treeNodesChanged(TreeModelEvent event) {
        VWTaskBaseNode parent = (VWTaskBaseNode)event.getTreePath().getLastPathComponent();
        VWTaskBaseNode node = null;
        Object[] children = event.getChildren();
        if (children != null && children.length > 0) {
            node = (VWTaskBaseNode)children[0];
        } else if (parent != null) {
            node = parent;
        }
        if (node != null) {
            VWTaskTablePanel tablePanel = parent.getContentPane().getTablePanel();
            if (tablePanel != null) {
                tablePanel.refresh();
            }
            if (this.m_focus == node) {
                this.fireVWTaskContentEvent(new VWTaskContentEvent(this, node));
            }
        }
    }

    public void treeStructureChanged(TreeModelEvent event) {
    }

    public void treeNodesInserted(TreeModelEvent event) {
    }

    public void treeNodesRemoved(TreeModelEvent event) {
        VWTaskBaseNode parent = (VWTaskBaseNode)event.getTreePath().getLastPathComponent();
        VWTaskTablePanel tablePanel = parent.getContentPane().getTablePanel();
        if (tablePanel != null) {
            tablePanel.refresh();
        }
    }

    private void fireActionEvent(ActionEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_actionListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    private void fireVWTaskContentEvent(VWTaskContentEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_contentListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != VWTaskContentListener.class) continue;
            ((VWTaskContentListener)listeners[i + 1]).taskContentChanged(event);
        }
    }
}

